#!/usr/bin/perl
#
#   vinay@csa.iisc.ernet.in 
#
#   You require perl/Tk to run this program. 
#   You should see a 3x3 grid, there are indexed in row major order.
#        
#        0 1 2
#        3 4 5
#        6 7 8
#
# Click the first button to form letters ... 
# Example: clicking on boxes 6 1 8 should output an "a"  etc
# Many characters have been mapped to the grid, look at the end of this
# file for the tap sequences.
#

#
# Integrated with libvirtkeys for intended functionality 13/2/2001 -Vivek
#

#
# Ctrl, Alt & Shift support added on 19/2/2001 -Vivek
#

#
# Digits can now be typed using the last 2 columns only:
#
#       1 2
#       4 5
#       7 8
#
# Added on 19/2/2001 -Vivek
# 
# Digit support removed, and new, shorter keystrokes (designed by Vinay)
# added. PC101 keyboard supported without digits and function keys.
# 26/3/2001 -Vivek
#
#

use Tk;
use libvirtkeys;

while (<DATA>) {
	chomp;
	my ($scan,$letter)=split;
	if ($letter=~/SPACE/) {$letter=" "}
	if ($letter=~/NEWLINE/) {$letter="\n"}
	if ($letter=~/TAB/) {$letter="\t"}
	if ($letter=~/BACK/) {$letter="\b \b"}
	$Key{$scan}=$letter;
}

$xoff=$yoff=15;
$x0=$xoff; $x1=$x0+30; $x2=$x1+30; $x3=$x2+30;
$y0=$yoff; $y1=$y0+30; $y2=$y1+30; $y3=$y2+30;

$$ctl_ref=0;
$$alt_ref=0;
$$sft_ref=0;
$$hld_ref=0;

$mw=MainWindow->new;
libvirtkeys::initsendkey();
$mw->focusmodel("active");

$canv=$mw->Canvas(-height=>120, -width=>120)->pack;
$canv->create('line', $x0,$y0,$x3,$y0);
$canv->create('line', $x0,$y1,$x3,$y1);
$canv->create('line', $x0,$y2,$x3,$y2);
$canv->create('line', $x0,$y3,$x3,$y3);
$canv->create('line', $x0,$y0,$x0,$y3);
$canv->create('line', $x1,$y0,$x1,$y3);
$canv->create('line', $x2,$y0,$x2,$y3);
$canv->create('line', $x3,$y0,$x3,$y3);

$meta_frame = $mw->Frame(-width=>120, -height=>50)->pack(-side=>'top');

$ctl_btn=$meta_frame->Checkbutton(-text => 'C', 
        -variable=> $ctl_ref,
        -command => \&hld_reset )->pack(-side=>'left');

$alt_btn=$meta_frame->Checkbutton(-text => 'A', 
        -variable=> $alt_ref,
        -command => \&hld_reset )->pack(-side=>'left');

$sft_btn=$meta_frame->Checkbutton(-text => 'S', 
        -variable=> $sft_ref,
        -command => \&hld_reset )->pack(-side=>'left');

$hld_btn=$meta_frame->Checkbutton(-text => 'L', 
        -variable=> $hld_ref,
        -command => \&hld_toggle )->pack(-side=>'left');

my $substr="";$prevx=-1;$prevy=-1;
$canv->Tk::bind('<1>'=>\&stroke);
MainLoop;

sub hld_reset {
    $$hld_ref = 0;
}

sub hld_toggle {
}

sub stroke{
	my $e=$canv->XEvent;
	my ($x,$y)=($e->x, $e->y);
	if ($x<$x0||$y<$y0||$x3<$x||$y3<$y) {
		$canv->delete('stroke');
		$substr="";$prevx=0;$prevy=0;
		return
	}
	if ($prevx>0) {
		$canv->create('line',$prevx,$prevy,$x,$y, -tag=>'stroke');
	}elsif ($prevx==0) {
		$canv->delete('stroke');
	}
	$canv->create('rect',$x-2,$y-2,$x+2,$y+2,-tag=>'stroke');
	my $xsh=$x-$xoff; my $ysh=$y-$yoff;
	my $xcoord=int($xsh/30);
	my $ycoord=int($ysh/30);
	my $box=$xcoord+3*$ycoord;
	$substr.=$box;

	if (exists $Key{$substr}) {
		#print "Sending $Key{$substr}";
		#print "Ctrl=$$ctl_ref,Alt=$$alt_ref,Shift=$$sft_ref";
        libvirtkeys::sendkey($Key{$substr},$$sft_ref,$$ctl_ref,$$alt_ref,0);
		$substr="";$prevx=0;$prevy=0;
        if($$hld_ref == 0)
        {
            $$sft_ref = 0;
            $$alt_ref = 0;
            $$ctl_ref = 0;
        }
		$canv->itemconfigure('stroke', -width=>2);
		return;
	}
	$prevx=$x;$prevy=$y;
}
__DATA__
618 Xa
023 Xb
238 Xc
056 Xd
137 Xe
217 Xf
237 Xg
35 Xh
17 Xi
284 Xj
260 Xk
067 Xl
607 Xm
608 Xn
262 Xo
6023 Xp
30148 Xq
60248 Xr
208 Xs
017 Xt
068 Xu
072 Xv
061 Xw
082 Xx
042 Xy
026 Xz
37 Xquoteleft
3042 Sasciitilde
036 Sexclam
568 Sat
012 Snumbersign
205 Sdollar
002 Spercent
315 Sasciicircum
168 Sampersand
642 Sasterisk
134 Sparenleft
154 Sparenright
12 Xminus
78 Sunderscore
4578 Xequal
34517 Splus
18 Xbackslash
258 Sbar
10 XBackSpace
68 XTab
037 Sbracketleft
257 Sbracketright
467 Sbraceleft
487 Sbraceright
57 XReturn
446 Xsemicolon
58 Scolon
0314 Squotedbl
27 Xslash
77 Xcomma
248 Sless
55 Xperiod
046 Sgreater
016 Squestion
67 Xspace
882 XUp
668 XRight
886 XLeft
228 XDown
